<?php

include("secure.php");
require('fpdf/fpdf.php');
require('connection_arrivals.php');
require('pdffunctions.php');

	
class PDF extends FPDF
{

	//include 'connection_arrivals.php';
	function Header()
	{
		global $title;
		global $Location;
		global $Address;
		global $con;
		
		$locationName = $_SESSION['codd_location'];
		if (strlen($locationName)>2)$locationName = str_replace("_"," ", $locationName );
		
		$Location = $locationName;
			
		$sql = "SELECT ADDRESS1, CITY, POSTCODE, LOCATIONID FROM locationdetails WHERE LOCATIONNAME = '$locationName'";
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$Address = $row[0].', ';
			$Address .= $row[1].', ';
			$Address .= $row[2];
			$LOCATIONID = $row[3];
		}
		
		$this->SetTextColor(50,50,50);
		$this->SetFillColor(255,255,255);
		$this->SetFont('Arial','B',14);
		$this->SetXY(20,14);
		
		$width = $this->w;
		if ($width>250){
			$lpos = $width-($width*0.14);
		}else{
			$lpos = $width-($width*0.18);
		}
		$this->Cell($lpos,6,$Location,0,0,'R',0);//$this->Cell(257,6,$Location,0,0,'R',0);
		$this->SetFont('Arial','',8);
		$this->SetXY(20,20);
		$this->Cell($lpos,3,$Address,0,0,'R',0);
		

		$this->Image('coddlogo.png',20,14,30);
		
		$this->Ln(10);
	}

	function Footer()
	{
		// Position at 1.5 cm from bottom
		$this->SetY(-15);
		// Arial italic 8
		$this->SetFont('Arial','I',8);
		// Text color in gray
		$this->SetTextColor(128);
		// Page number
		//$this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
		$this->AliasNbPages('{totalPages}');
		$this->Cell(0,10,'Page '.$this->PageNo().'/{totalPages}',0,0,'C');
	}

	

	function SetCol($col)
	{
		// Set position at a given column
		$this->col = $col;
		$x = 10+$col*65;
		$this->SetLeftMargin($x);
		$this->SetX($x);
	}
	
	

	
}
	
	
	if(!isset($_SESSION)){
		session_start();
	}
	$fromDate = $_SESSION['codd_fdate'];
	$toDate = $_SESSION['codd_tdate'];
	$locationName = $_SESSION['codd_location'];
	$LOCATIONID = $_GET['lid'];
	$USERID = $_GET['uid'];
	
	$DOCTORNAME = 'Dr. '.doctorname($LOCATIONID, $USERID);

	$pdf = new PDF();
	$pdf->SetTitle($title);
	$pdf->SetAuthor('Codd Technologies');

	//$pdf->AddPage();

	$y_axis_initial = 30;
	$y_axis = 30;
	$row_height=8;

	
	$pdf->addPage('P');
	$pdf->SetDrawColor(50,50,50);			
	$pdf->SetFillColor(221,220,220);
	$pdf->SetTextColor(50,50,50);
	$pdf->SetFont('Helvetica','B',14);

	$pdf->SetLineWidth(2);
	$pdf->SetDrawColor(69,118,194);	
	$pdf->Line(21, 30, 190, 30);
	$pdf->SetDrawColor(153,201,71);
	$pdf->SetLineWidth(2);
	$pdf->Line(21, 28.75, 190, 28.75);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(50,50,50);
	
	/* $pdf->SetFont('Helvetica','',10);
	$pdf->SetXY(30, 30);
	$pdf->SetFillColor(255,255,255);
	$pdf->SetDrawColor(255,255,255);
	$pdf->SetTextColor(100,100,100);
	$pdf->Cell(159,9,$DOCTORNAME,1,0,'R',1);
	$pdf->SetFont('Helvetica','B',14);
	$pdf->SetFillColor(221,220,220);
	$pdf->SetDrawColor(50,50,50);
	$pdf->SetTextColor(50,50,50); */
	
	$y_axis = $y_axis_initial + $row_height;
	
	
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(171,8,'Doctor Report from '.date("d-m-Y", strtotime($fromDate)).' to '.date("d-m-Y", strtotime($toDate)),1,0,'C',1);
	$pdf->SetFillColor(255,255,255);
	

	$y_axis = $y_axis + $row_height*2;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(46,9,'Name',1,0,'L',1);
	$pdf->Cell(125,9,$DOCTORNAME,1,0,'C',1);

	$y_axis = $y_axis + $row_height*2;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(171,8,'Patient Demographics',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(30,9,'Patient Age',1,0,'L',1);
	$pdf->Cell(29,9,'Count ',1,0,'L',1);
	$pdf->Cell(28,9,'One Visit',1,0,'L',1);
	$pdf->Cell(28,9,'Two Visit',1,0,'L',1);
	$pdf->Cell(28,9,'Three Visit',1,0,'L',1);
	$pdf->Cell(28,9,'Four+ Visit',1,0,'L',1);
	
	$tcount =0;$tone =0;$ttwo =0;$tthree =0;$tfour =0;
	
	for($i=0; $i<11; $i++){
		$age = ''; $ages='';$sage=0;$eage=0;
		
		$count =0;$one =0;$two =0;$three =0;$four =0;
		if($i==0){ $age ='<1'; $sage=0; $eage=0; $ages='AGE1';}
		if($i==1){ $age ='1-5'; $sage=1; $eage=5; $ages='AGE15';}
		if($i==2){ $age ='6-16'; $sage=6; $eage=16; $ages='AGE616';}
		if($i==3){ $age ='17-19'; $sage=17; $eage=19; $ages='AGE1719';}
		if($i==4){ $age ='20-40'; $sage=20; $eage=40; $ages='AGE2040';}
		if($i==5){ $age ='41-44'; $sage=41; $eage=44; $ages='AGE4144';}
		if($i==6){ $age ='45-49'; $sage=45; $eage=49; $ages='AGE4549';}
		if($i==7){ $age ='50-65'; $sage=50; $eage=65; $ages='AGE5065';}
		if($i==8){ $age ='66-75'; $sage=66; $eage=75; $ages='AGE6675';}
		if($i==9){ $age ='>75'; $sage=75; $eage=300; $ages='AGE75';}
		
		$count = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "0", $sage, $eage);
		$one = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "1", $sage, $eage);
		$two = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "2", $sage, $eage);
		$three = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "3", $sage, $eage);
		$four = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "4", $sage, $eage); 
		
		$tcount += $count;
		$tone += $one;
		$ttwo += $two;
		$tthree += $three;
		$tfour += $four;
		
		if($i<10){
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->Cell(30,9,$age,1,0,'L',1);
			$pdf->Cell(29,9,$count,1,0,'R',1);
			$pdf->Cell(28,9,$one,1,0,'R',1);
			$pdf->Cell(28,9,$two,1,0,'R',1);
			$pdf->Cell(28,9,$three,1,0,'R',1);
			$pdf->Cell(28,9,$four,1,0,'R',1);
		}else{
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->Cell(30,9,'Total',1,0,'L',1);
			$pdf->Cell(29,9,$tcount,1,0,'R',1);
			$pdf->Cell(28,9,$tone,1,0,'R',1);
			$pdf->Cell(28,9,$ttwo,1,0,'R',1);
			$pdf->Cell(28,9,$tthree,1,0,'R',1);
			$pdf->Cell(28,9,$tfour,1,0,'R',1);
		}
		
		
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	$totalpatients = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "0", 0, 300);
	$totalpatients20 = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "0", 20, 300);
	//$totalpatients20 = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "PNTCOUNT20");
	$bpnotrecorded = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BPNOTDONE");
	if($bpnotrecorded>$totalpatients20)$bpnotrecorded = $totalpatients20;
	$bprecorded = $totalpatients20 - $bpnotrecorded;
	$bphigh = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BPH");
	$bplow = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BPL");
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//BLOOD PRESSURE
	$y_axis = $y_axis + $row_height*2;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(255,255,255);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(71,8,'Description',1,0,'C',1);
	$pdf->Cell(50,8,'Recorded',1,0,'C',1);
	$pdf->Cell(50,8,'Not Recorded',1,0,'C',1);
	
	
	$pdf->SetFillColor(221,220,220);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Blood Pressure (Age: >20)',1,0,'L',1);//.$totalpatients20
	$pdf->Cell(50,9,$bprecorded,1,0,'C',1);
	$pdf->Cell(50,9,$bpnotrecorded,1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Systolic : >140',1,0,'L',1);
	$pdf->Cell(50,9,$bphigh,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Diastolic : >90',1,0,'L',1);
	$pdf->Cell(50,9,$bplow,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	//$totalpatients = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "PNTCOUNT");
	//$totalpatients = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "0", 0, 300);
	
	$bminotrecorded = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BMINOTDONE");
	if($bminotrecorded>$totalpatients20)$bminotrecorded = $totalpatients20;
	$bmirecorded = $totalpatients20 - $bminotrecorded;
	$bmi25 = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BMI25");
	$bmi2530 = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BMI2530");
	$bmi2535 = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BMI2535");
	$bmi3035 = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BMI3035");
	$bmi3540 = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BMI3540");
	$bmi40 = doc_bpbmi($LOCATIONID, $USERID, $fromDate, $toDate, "BMI40");
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//BMI
	$pdf->SetFillColor(221,220,220);
	
	$y_axis = $y_axis + $row_height*2;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'BMI',1,0,'L',1);
	$pdf->Cell(50,9,$bmirecorded,1,0,'C',1);
	$pdf->Cell(50,9,$bminotrecorded,1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'<25',1,0,'L',1);
	$pdf->Cell(50,9,$bmi25,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'25-30',1,0,'L',1);
	$pdf->Cell(50,9,$bmi2530,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'30-35',1,0,'L',1);
	$pdf->Cell(50,9,$bmi3035,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'35-40',1,0,'L',1);
	$pdf->Cell(50,9,$bmi3540,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'>40',1,0,'L',1);
	$pdf->Cell(50,9,$bmi40,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	
	$y_axis = 30;
	$pdf->addPage('P');
	$pdf->SetDrawColor(50,50,50);			
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);

	$pdf->SetXY(20, $y_axis);
	
	$pdf->SetLineWidth(2);
	$pdf->SetDrawColor(69,118,194);	
	$pdf->Line(21, 30, 190, 30);
	$pdf->SetDrawColor(153,201,71);
	$pdf->SetLineWidth(2);
	$pdf->Line(21, 28.75, 190, 28.75);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(50,50,50);
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	$smokingnotdone = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "SMOKINGNOTDONE");
	$smokingdone = $totalpatients20 - $smokingnotdone;
	$smokingnone = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "NONSMOKERS");
	$smokingex = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "EXSMOKERS");
	$smokers = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "SMOKERS");
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//SMOKING
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(255,255,255);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(71,8,'Description',1,0,'C',1);
	$pdf->Cell(50,8,'Recorded',1,0,'C',1);
	$pdf->Cell(50,8,'Not Recorded',1,0,'C',1);
	
	
	$pdf->SetFillColor(221,220,220);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Smoking (Age:>20)',1,0,'L',1);
	$pdf->Cell(50,9,$smokingdone,1,0,'C',1);
	$pdf->Cell(50,9,$smokingnotdone,1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Smoker',1,0,'L',1);
	$pdf->Cell(50,9,$smokers,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Ex-smoker',1,0,'L',1);
	$pdf->Cell(50,9,$smokingex,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Non Smoker',1,0,'L',1);
	$pdf->Cell(50,9,$smokingnone,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	$allergiesnotdone = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "ALLERGIESNOTDONE");
	$allergiesdone = $totalpatients - $allergiesnotdone;
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//Allergies
	$pdf->SetFillColor(221,220,220);	
	$y_axis = $y_axis + $row_height*3;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'Allergies',1,0,'L',1);
	$pdf->Cell(50,9,$allergiesdone,1,0,'C',1);
	$pdf->Cell(50,9,$allergiesnotdone,1,0,'C',1);
	
	
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	$hba1cdone = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "HBA1CDONE");
	$hba1cnotdone = $totalpatients - $hba1cdone;
	$hba1c7 = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "HBA1C7");
	$hba1c78 = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "HBA1C78");
	$hba1c8 = doc_clinical($LOCATIONID, $USERID, $fromDate, $toDate, "HBA1C8");
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//HBA1C
	$pdf->SetFillColor(221,220,220);
	
	$y_axis = $y_axis + $row_height*3;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'HbA1c',1,0,'L',1);
	$pdf->Cell(50,9,$hba1cdone,1,0,'C',1);
	$pdf->Cell(50,9,$hba1cnotdone,1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'<7',1,0,'L',1);
	$pdf->Cell(50,9,$hba1c7,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'7-8',1,0,'L',1);
	$pdf->Cell(50,9,$hba1c78,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(71,9,'>8',1,0,'L',1);
	$pdf->Cell(50,9,$hba1c8,1,0,'C',1);
	$pdf->Cell(50,9,' ',1,0,'C',1);
	
	
	//CHRONIC DIEASES
	$y_axis = $y_axis + $row_height*3;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(171,8,'Chronic Disease Management',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(51,9,'Chronic Disease',1,0,'C',1);
	$pdf->Cell(40,9,'Count',1,0,'C',1);
	$pdf->Cell(40,9,'On M.P.',1,0,'C',1);
	$pdf->Cell(40,9,'Not on M.P.',1,0,'C',1);
	
	$tcount =0; $tmp =0; $tnonmp =0;
	
	for($i=0; $i<8; $i++){
		$dname = '';
		if($i==0){ $dname ='Asthma'; }
		if($i==1){ $dname ='IHD'; }
		if($i==2){ $dname ='Diabetes'; }
		if($i==3){ $dname ='Osteoarthritis'; }
		if($i==4){ $dname ='Osteoporosis'; }
		if($i==5){ $dname ='COPD'; }
		if($i==6){ $dname ='Stroke'; }
		
		$count = doc_chronic($LOCATIONID, $USERID, $fromDate, $toDate, $dname);
		$mp = doc_chronic_mp($LOCATIONID, $USERID, $fromDate, $toDate, $dname);
		$nonmp = $count - $mp;
		
		
		
		if($i<7){
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->Cell(51,9,$dname,1,0,'L',1);
			$pdf->Cell(40,9,$count,1,0,'R',1);
			$pdf->Cell(40,9,$mp,1,0,'R',1);
			$pdf->Cell(40,9,$nonmp,1,0,'R',1);
			$tcount +=$count;
			$tmp +=$mp; 
			$tnonmp +=$nonmp;
		}else{
			
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->Cell(51,9,'Total',1,0,'L',1);
			$pdf->Cell(40,9,$tcount,1,0,'R',1);
			$pdf->Cell(40,9,$tmp,1,0,'R',1);
			$pdf->Cell(40,9,$tnonmp,1,0,'R',1);
		}
	}
	
	
	
	
	$y_axis = 30;
	$pdf->addPage('P');
	$pdf->SetDrawColor(50,50,50);			
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);

	$pdf->SetXY(20, $y_axis);
	
	$pdf->SetLineWidth(2);
	$pdf->SetDrawColor(69,118,194);	
	$pdf->Line(21, 30, 190, 30);
	$pdf->SetDrawColor(153,201,71);
	$pdf->SetLineWidth(2);
	$pdf->Line(21, 28.75, 190, 28.75);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(50,50,50);
	
	//Health Assesment
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(171,8,'Health Assessment',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(51,9,'Age',1,0,'C',1);
	$pdf->Cell(40,9,'Count',1,0,'C',1);
	$pdf->Cell(40,9,'Due',1,0,'C',1);
	$pdf->Cell(40,9,'Done',1,0,'C',1);
	
	$hadtotal =0;
	for($i=0; $i<3; $i++){
		$iname = '';$cond=0;$cond1=0;$sage=0; $eage=0;
		
		if($i==0){ $iname ='45-49 old (5years)'; $cond=1; $cond1=3; $sage=45; $eage=49;}
		if($i==1){ $iname ='>75 (12 months)'; $cond=2; $cond1=4; $sage=75; $eage=200;}
		if($i==2){ $iname ='Total'; $cond=0; $cond1=5; $sage=0; $eage=200;}
		
		$hadvalue = doc_had($LOCATIONID, $USERID, $fromDate, $toDate, $cond);
		$haddone = doc_had($LOCATIONID, $USERID, $fromDate, $toDate, $cond1);
		$count = visitcount($LOCATIONID, $USERID, $fromDate, $toDate, "0", $sage, $eage);
		
		$hadtotal += $hadvalue + $haddone;
		
		if($i<2){
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->SetFont('Helvetica','B',14);
			$pdf->Cell(51,9,$iname,1,0,'L',1);
			$pdf->Cell(40,9,$count,1,0,'R',1);
			$pdf->Cell(40,9,$hadvalue,1,0,'R',1);
			$pdf->Cell(40,9,$haddone,1,0,'R',1);
		}else{
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->Cell(51,9,'Total',1,0,'L',1);
			$pdf->Cell(40,9,$hadtotal,1,0,'R',1);
			$pdf->Cell(40,9,$hadvalue,1,0,'R',1);
			$pdf->Cell(40,9,$haddone,1,0,'R',1);
		}
	}
	
	
	//BILLINGS
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	$ppa = perpatientaverage($LOCATIONID, $USERID, $fromDate, $toDate);
	$appts_available = analytics($LOCATIONID, $USERID, $fromDate, $toDate, "TOTAL_APTS");
	$appts_booked = analytics($LOCATIONID, $USERID, $fromDate, $toDate, "BOOKED_APTS");
	$appts_completed = analytics($LOCATIONID, $USERID, $fromDate, $toDate, "COMPLETED_APTS");
	$appts_dna = $appts_booked - $appts_completed;
	$appts_free = analytics($LOCATIONID, $USERID, $fromDate, $toDate, "FREE_APTS");
	$appts_fees = analytics($LOCATIONID, $USERID, $fromDate, $toDate, "TOTAL_FEES");
	$noofdays = noofdays($fromDate,$toDate);
	$noofdays += 1;
	$pfromDate = date('Y-m-d', strtotime("+1 day", strtotime($toDate)));
	$ptoDate = date('Y-m-d', strtotime("+".$noofdays." day", strtotime($toDate)));
	$appts_future = analytics($LOCATIONID, $USERID, $pfromDate, $ptoDate, "TOTAL_APTS");
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	
	$y_axis = $y_axis + $row_height*3;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(171,8,'Billing Details',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(91,9,'P.P.A.',1,0,'L',1);
	$pdf->Cell(80,9,'$ '.number_format($ppa,2),1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(91,9,'Available Appointments',1,0,'L',1);
	$pdf->Cell(80,9,$appts_available,1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(91,9,'Booked Appointments',1,0,'L',1);
	$pdf->Cell(80,9,$appts_booked,1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(91,9,'Completed Appointments',1,0,'L',1);
	$pdf->Cell(80,9,$appts_completed,1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(91,9,'DNA',1,0,'L',1);
	$pdf->Cell(80,9,$appts_dna,1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(91,9,'Free Appointments',1,0,'L',1);
	$pdf->Cell(80,9,$appts_free,1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(91,9,'Billing form '.date("d-m-Y", strtotime($fromDate)).' to '.date("d-m-Y", strtotime($toDate)),1,0,'L',1);
	$pdf->Cell(80,9,'$ '.number_format($appts_fees,2),1,0,'R',1);
	
	
	//PREDICTED EARNINGS
	$y_axis = $y_axis + $row_height*3;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(171,8,'Predicted Earnings from '.date("d-m-Y", strtotime($pfromDate)).' to '.date("d-m-Y", strtotime($ptoDate)).' ('.$noofdays.' days)',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,'Appointments',1,0,'C',1);
	$pdf->Cell(57,9,'P.P.A.',1,0,'C',1);
	$pdf->Cell(57,9,'Predicted Earnings',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,$appts_future,1,0,'C',1);
	$pdf->Cell(57,9,'$ '.number_format($ppa,2),1,0,'C',1);
	$pdf->Cell(57,9,'$ '.number_format($ppa*$appts_future,2),1,0,'C',1);
	
	
	//PREDICTED EARNINGS ANALYSIS
	$y_axis = $y_axis + $row_height*3;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(171,8,'Predicted Earnings Analysis',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,'P.P.A.',1,0,'C',1);
	$pdf->Cell(57,9,'Appointments',1,0,'C',1);
	$pdf->Cell(57,9,'Predicted Earnings',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,'$ '.number_format($ppa+2,2) ,1,0,'C',1);
	$pdf->Cell(57,9,$appts_future,1,0,'R',1);
	$pdf->Cell(57,9,'$ '.number_format(($ppa+2)*$appts_future,2),1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,'$ '.number_format($ppa+4,2) ,1,0,'C',1);
	$pdf->Cell(57,9,$appts_future,1,0,'R',1);
	$pdf->Cell(57,9,'$ '.number_format(($ppa+4)*$appts_future,2),1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,'$ '.number_format($ppa+6,2) ,1,0,'C',1);
	$pdf->Cell(57,9,$appts_future,1,0,'R',1);
	$pdf->Cell(57,9,'$ '.number_format(($ppa+6)*$appts_future,2),1,0,'R',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,'$ '.number_format($ppa+8,2) ,1,0,'C',1);
	$pdf->Cell(57,9,$appts_future,1,0,'R',1);
	$pdf->Cell(57,9,'$ '.number_format(($ppa+8)*$appts_future,2),1,0,'R',1);
		
	$pdf->SetFillColor(255,255,255);
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(57,9,'$ '.number_format($ppa+10,2) ,1,0,'C',1);
	$pdf->Cell(57,9,$appts_future,1,0,'R',1);
	$pdf->Cell(57,9,'$ '.number_format(($ppa+10)*$appts_future,2),1,0,'R',1);
	
	
	$y_axis = 30;
	$pdf->addPage('P');
	$pdf->SetDrawColor(50,50,50);			
	$pdf->SetFillColor(221,220,220);
	
	$pdf->SetFont('Helvetica','B',14);

	$pdf->SetXY(20, $y_axis);
	
	$pdf->SetLineWidth(2);
	$pdf->SetDrawColor(69,118,194);	
	$pdf->Line(21, 30, 190, 30);
	$pdf->SetDrawColor(153,201,71);
	$pdf->SetLineWidth(2);
	$pdf->Line(21, 28.75, 190, 28.75);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(50,50,50);
	
	//ITEM NUMBERS
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->SetFillColor(221,220,220);	
	$pdf->SetFont('Helvetica','B',14);
	$pdf->Cell(171,8,'Item Numbers Analysis',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);	
	$y_axis = $y_axis + $row_height;
	$pdf->SetXY(20, $y_axis);
	$pdf->Cell(86,9,'Item Number',1,0,'C',1);
	$pdf->Cell(85,9,'Count',1,0,'C',1);
	
	$pdf->SetFillColor(255,255,255);
	
	$i=0;
	$sql = "SELECT ITEMNUM, COUNT(ITEMNUM) FROM itemnum_".$LOCATIONID." WHERE USERID = '".$USERID."' AND DATEOFSERVICE >= '".$fromDate."' AND DATEOFSERVICE <= '".$toDate."' GROUP BY ITEMNUM ORDER BY ITEMNUM";
	$result = mysqli_query($con,$sql);
	while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
		$out = $row[0];
		$y_axis = $y_axis + $row_height;
		$pdf->SetXY(20, $y_axis);
		$pdf->Cell(86,9,$row[0],1,0,'R',1);
		$pdf->Cell(85,9,$row[1],1,0,'R',1);
		
		$i += 1;
		if($i==25 || $i==50){
			$y_axis = 30;
			$pdf->addPage('P');
			$pdf->SetDrawColor(50,50,50);			
			$pdf->SetFillColor(221,220,220);
			$pdf->SetXY(20, $y_axis);
			
			$pdf->SetLineWidth(2);
			$pdf->SetDrawColor(69,118,194);	
			$pdf->Line(21, 30, 190, 30);
			$pdf->SetDrawColor(153,201,71);
			$pdf->SetLineWidth(2);
			$pdf->Line(21, 28.75, 190, 28.75);
			$pdf->SetLineWidth(0.2);
			$pdf->SetDrawColor(50,50,50);
			
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->SetFillColor(221,220,220);	
			$pdf->SetFont('Helvetica','B',14);
			$pdf->Cell(171,8,'Item Numbers Analysis',1,0,'C',1);
	
			$pdf->SetFillColor(255,255,255);	
			$y_axis = $y_axis + $row_height;
			$pdf->SetXY(20, $y_axis);
			$pdf->Cell(86,9,'Item Number',1,0,'C',1);
			$pdf->Cell(85,9,'Count',1,0,'C',1);
			
			$pdf->SetFillColor(255,255,255);
		}
	}
	
	
	
	$docname = str_replace("_"," ", $DOCTORNAME );
	$filename = $locationName .'_'.$docname.'.pdf';
	$pdf->Output('D',$filename);//Output();

	
?>
