<?php
	require('connection_arrivals.php');
	
	function doc_chronic($LOCATIONID, $USERID, $FDATE, $TDATE, $ITEM)
	{
		global $con;
		$out =0;
		
		if($ITEM=='Asthma')$ITEM = " AND ASTHMA>0 ";
		if($ITEM=='IHD')$ITEM = " AND IHD>0 ";
		if($ITEM=='Diabetes')$ITEM = " AND Diabetes>0 ";
		if($ITEM=='Osteoarthritis')$ITEM = " AND Osteoarthritis>0 ";
		if($ITEM=='Osteoporosis')$ITEM = " AND Osteoporosis>0 ";
		if($ITEM=='COPD')$ITEM = " AND COPD>0 ";
		if($ITEM=='Stroke')$ITEM = " AND Stroke>0 ";
		if($ITEM=='MP')$ITEM = " AND MP>0 ";
		
		$sql = "SELECT COUNT(DISTINCT PNTID) FROM `doc_chronic_ind_".$LOCATIONID."` WHERE USERID='".$USERID."' AND BDATE >= '".$FDATE."' AND BDATE <= '".$TDATE."' ".$ITEM." GROUP BY USERID";
				
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$out = $row[0];
		}
		
		
		return $out;
	}
	
	function doc_chronic_mp($LOCATIONID, $USERID, $FDATE, $TDATE, $ITEM)
	{
		global $con;
		$out =0;
		
		if($ITEM=='Asthma')$ITEM = " AND ASTHMA>0 AND MP> 0 ";
		if($ITEM=='IHD')$ITEM = " AND IHD>0 AND MP> 0 ";
		if($ITEM=='Diabetes')$ITEM = " AND Diabetes>0 AND MP> 0 ";
		if($ITEM=='Osteoarthritis')$ITEM = " AND Osteoarthritis>0 AND MP> 0 ";
		if($ITEM=='Osteoporosis')$ITEM = " AND Osteoporosis>0 AND MP> 0 ";
		if($ITEM=='COPD')$ITEM = " AND COPD>0 AND MP> 0 ";
		if($ITEM=='Stroke')$ITEM = " AND Stroke>0 AND MP> 0 ";
		
		$sql = "SELECT COUNT(DISTINCT PNTID) FROM `doc_chronic_ind_".$LOCATIONID."` WHERE USERID='".$USERID."' AND BDATE >= '".$FDATE."' AND BDATE <= '".$TDATE."' ".$ITEM." GROUP BY USERID";
				
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$out = $row[0];
		}
		
		
		return $out;
	}
	
	function doc_clinical($LOCATIONID, $USERID, $FDATE, $TDATE, $ITEM)
	{
		global $con;
		$out =0;
		
		if($ITEM=='SMOKINGNOTDONE')$ITEM = " AND SMOKING=0 AND AGE >20 ";
		if($ITEM=='NONSMOKERS')$ITEM = " AND SMOKING=1 AND AGE >20 ";
		if($ITEM=='EXSMOKERS')$ITEM = " AND SMOKING=2 AND AGE >20 ";
		if($ITEM=='SMOKERS')$ITEM = " AND SMOKING=3 AND AGE >20 ";
		
		if($ITEM=='HBA1CDONE')$ITEM = " AND HBA1C>0 AND AGE >20 ";
		if($ITEM=='HBA1C7')$ITEM = " AND HBA1C>0 AND HBA1C<7 AND AGE >20 ";
		if($ITEM=='HBA1C78')$ITEM = " AND HBA1C>=7 AND HBA1C<=8 AND AGE >20 ";
		if($ITEM=='HBA1C8')$ITEM = " AND HBA1C>8 AND AGE >20 ";
		
		if($ITEM=='ALLERGIESNOTDONE')$ITEM = " AND ALLERGIES=0 ";
		
		$sql = "SELECT COUNT(DISTINCT PNTID) FROM `doc_smalhb_".$LOCATIONID."` WHERE USERID='".$USERID."' AND BDATE >= '".$FDATE."' AND BDATE <= '".$TDATE."' ".$ITEM." GROUP BY USERID";
				
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$out = $row[0];
		}
		
		return $out;
	}
	
	
	function doc_bpbmi($LOCATIONID, $USERID, $FDATE, $TDATE, $ITEM)
	{
		global $con;
		$out =0;
		
		if($ITEM=='BPH')$ITEM = " AND BPH>140 AND AGE >20 ";
		if($ITEM=='BPL')$ITEM = " AND BPL>90 AND AGE >20 ";
		if($ITEM=='BPNOTDONE')$ITEM = " AND BPH=0 AND AGE >20 ";
		
		if($ITEM=='BMI25')$ITEM = " AND BMI>0 AND BMI<25 AND AGE >20 ";
		if($ITEM=='BMI2530')$ITEM = " AND BMI>=25 AND BMI <30 AND AGE >20 ";
		if($ITEM=='BMI3035')$ITEM = " AND BMI>=30 AND BMI <35 AND AGE >20 ";
		if($ITEM=='BMI3540')$ITEM = " AND BMI>=35 AND BMI <40 AND AGE >20 ";
		if($ITEM=='BMI40')$ITEM = " AND BMI>=40 AND AGE >20 ";
		if($ITEM=='BMINOTDONE')$ITEM = " AND (BMI=0 OR BMI='**.*') AND AGE >20 ";
		
		$sql = "SELECT COUNT(DISTINCT PNTID) FROM `doc_bpbmi_".$LOCATIONID."` WHERE USERID='".$USERID."' AND BDATE >= '".$FDATE."' AND BDATE <= '".$TDATE."' ".$ITEM." GROUP BY USERID";
				
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$out = $row[0];
		}
		
		return $out;
	}
	
	
	
	function doc_had($LOCATIONID, $USERID, $FDATE, $TDATE, $COND)
	{
		global $con;
		$out =0;$TEXT='';
		
		if($COND==1)$TEXT = " AND AGE>=45 AND AGE <=49 ";
		if($COND==2)$TEXT = " AND AGE>=75 ";
		if($COND==3)$TEXT = "  AND AGE>=45 AND AGE <=49 AND HADDONE>0 ";
		if($COND==4)$TEXT = "  AND AGE>=75 AND HADDONE>0 ";
		if($COND==5)$TEXT = "  AND HADDONE>0 ";
		
		$sql = "SELECT COUNT(DISTINCT PNTID) FROM `doc_had_".$LOCATIONID."` WHERE USERID='".$USERID."' AND HDATE >= '".$FDATE."' AND HDATE <= '".$TDATE."' ".$TEXT." GROUP BY USERID";
		
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$out = $row[0];
		}
		
		return $out;
	}
	
	function noofdays($start, $end) {
		$start1 = strtotime($start);
		$end1 = strtotime($end);
		$days_between = ceil(abs($end1 - $start1) / 86400);
		return $days_between;
	}
	
	function perpatientaverage($LOCATIONID, $USERID, $FDATE, $TDATE)
	{
		global $con;
		$compapts = 0;
		$per =0;
		$earnings =0;
		
		$sql = "(SELECT  SUM(A.TOTAL_FEES), SUM(A.COMPLETED_APTS) FROM analytics_".$LOCATIONID." A WHERE (A.BOOKED_APTS >2 OR (A.FREE_APTS-A.UNAVAIL_APTS) >1) AND A.ANADATE >= '".$FDATE."' AND A.ANADATE <= '".$TDATE."' AND A.USERID IN ( SELECT C.USERID FROM users_".$LOCATIONID." C WHERE (C.GROUPCODE=3 OR C.GROUPCODE=4) ) GROUP BY A.USERID)";
		
		if($USERID>1)$sql = "SELECT  SUM(A.TOTAL_FEES), SUM(A.COMPLETED_APTS) FROM analytics_".$LOCATIONID." A WHERE (A.BOOKED_APTS >2 OR (A.FREE_APTS-A.UNAVAIL_APTS) >1) AND A.ANADATE >= '".$FDATE."' AND A.ANADATE <= '".$TDATE."' AND A.USERID='".$USERID."'";
		
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$earnings += $row[0];
			$compapts += $row[1];
		}
		if($earnings>0)$per = $earnings / $compapts ;
		return $per;
	}
	
	function visitcount($LOCATIONID, $USERID, $FDATE, $TDATE, $VISIT, $FAGE, $TAGE)
	{
		
		global $con;
		
		$vcnt =0;
		$four=0; $three=0; $two=0; $one=0; $total=0;
		
		$sqll2 ="SELECT COUNT(PNTID) FROM visitnos_".$LOCATIONID." WHERE USERID ='".$USERID."' AND INVDATE >='".$FDATE."' AND INVDATE <= '".$TDATE."' AND PNTID IN (SELECT INTERNALID FROM pnthis_".$LOCATIONID." WHERE TIMESTAMPDIFF(YEAR, DOB, CURDATE())>=".$FAGE." AND TIMESTAMPDIFF(YEAR, DOB, CURDATE())<=".$TAGE." ) GROUP BY PNTID";// AGE CALCULATED FOR TODATE FROM DOB
		
		//$sqll2 ="SELECT COUNT(PNTID) FROM visitnos_".$LOCATIONID." WHERE USERID ='".$USERID."' AND INVDATE >='".$FDATE."' AND INVDATE <= '".$TDATE."' GROUP BY PNTID";
		
		$recSetl2 = mysqli_query($con,$sqll2);
		while($reck = mysqli_fetch_array($recSetl2)){

				$count = (int)$reck[0];
				if ($count>3)$four +=1;
				if ($count==3)$three +=1;
				if ($count==2)$two +=1;
				if ($count==1)$one +=1;
				$total+=1;

		}
			
		if($VISIT=="1")$vcnt = $one;
		if($VISIT=="2")$vcnt = $two;
		if($VISIT=="3")$vcnt = $three;
		if($VISIT=="4")$vcnt = $four;
		if($VISIT=="0")$vcnt = $total;
		
		return $vcnt;
	}
	
	function analytics($LOCATIONID, $USERID, $FDATE, $TDATE, $ITEM)
	{
		global $con;
		$out =0;
		
		$sql = "SELECT SUM(".$ITEM.") FROM `analytics_".$LOCATIONID."` WHERE (BOOKED_APTS >2 OR (FREE_APTS-UNAVAIL_APTS) >1) AND USERID='".$USERID."' AND ANADATE >= '".$FDATE."' AND ANADATE <= '".$TDATE."' GROUP BY USERID";
				
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$out = $row[0];
		}
		
		return $out;
	}
	
	
	
	
	

	
	function doctorname($LOCATIONID, $USERID)
	{
		global $con;
		$output = '';
		
		$sql = "SELECT  CONCAT(A.FIRSTNAME,' ', A.SURNAME) FROM analytics_".$LOCATIONID." A WHERE A.USERID='".$USERID."';";
		
		$result = mysqli_query($con,$sql);
		while($row = mysqli_fetch_array($result , MYSQLI_BOTH)){
			$output = $row[0];
		}
		return $output;
	}
?>