<?php

require('fpdf/fpdf.php');
require('connection_arrivals.php');
class PDF extends FPDF
{
function Header()
{
   global $name;
    global $medical_name;
    $search_date =$name;

		$medical_name = "Task Management";
		$search_date = str_replace('_', ' ', $search_date);

		$this->SetDrawColor(13, 13, 13);
   		$this->SetLineWidth(.0);
   		$this->Rect(5, 5, 200, 287, 'D'); //For A4

   		$this->SetTextColor(50,50,50);
		$this->SetFillColor(255,255,255);
		$this->SetFont('Arial','B',14);
		$this->SetXY(20,14);
		
		$width = $this->w;
		if ($width>250){
			$lpos = $width-($width*0.14);
		}else{
			$lpos = $width-($width*0.18);
		}
			
		$this->Image('coddlogo.png',20,14,30);
		
		$this->SetX((300-$w)/2);
    
		    $this->SetDrawColor(255,255,255);
		    $this->SetFillColor(255,255,255);
		    $this->SetTextColor(13,13,13);
		    $this->SetLineWidth(1);
		    // Title
		    $this->Cell($w,9,$medical_name,1,1,'C',true);

		    // Line break

		    $this->Ln(5);
		//$this->Ln(10);

    		$w = $this->GetStringWidth($search_date)+6;
    		$this->SetX((280-$w)/2);
    
		    $this->SetDrawColor(255,255,255);
		    $this->SetFillColor(255,255,255);
		    $this->SetTextColor(13,13,13);
		    $this->SetLineWidth(1);
		    // Title
		    $this->Cell($w,9,$search_date,1,1,'C',true);


		global $id;
		global $con;

		$sql = "SELECT a.FIELD_NAME,t.TASKNAME,t.STARTDATE,t.STAKEHOLDERS,t.PROCESS,t.CONMM,t.RISKMM,t.COST,t.ENDDATE FROM tasks t LEFT JOIN admin_users a ON a.ID = t.USERID WHERE t.TASKID = '".$id."'";

			$CREATEDNAME = '';
			$TASKNAME = '';
			$STARTDATE = '';
			$STAKEHOLDERS ='';
			$PROCESS = '';
			$CONMM = '';
			$RISKMM = '';
			$COST = '';
			$ENDDATE = '';

		$recSet = mysqli_query($con,$sql);
		while($rec = mysqli_fetch_array($recSet)){

			$CREATEDNAME = $rec[0];
			$TASKNAME = $rec[1];
			$STARTDATE = $rec[2];
			$STAKEHOLDERS = $rec[3];
			$PROCESS = $rec[4];
			$CONMM = $rec[5];
			$RISKMM = $rec[6];
			$COST = $rec[7];
			$ENDDATE = $rec[8];

		}

		

		

		// TASK NAME
		$this->Ln(2);
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(17,8,'Task Name',0,0,'C');

		

		$this->Ln();
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);
		$this->Cell(24,8,$TASKNAME,0,0);

		// START DATE
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(15,8,'Start Date',0,0,'C');

		$this->Ln();
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);
		$this->Cell(50,8,$STARTDATE,0,0);

		// END DATE
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(14,8,'End Date',0,0,'C');

		$this->Ln();
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);
		$this->Cell(50,8,$ENDDATE,0,0);

		// Stakeholders
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(20,8,'Stakeholders',0,0,'C');

		
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);

		$output = preg_split('/[\.|\s]/', $STAKEHOLDERS, -1, PREG_SPLIT_NO_EMPTY);
		array_walk($output, function(&$item, $idx) {

			global $con;
			$tsql = "SELECT FIELD_NAME FROM admin_users WHERE ID ='".$item."'";

			
			$trecSet = mysqli_query($con,$tsql);
			
			while($trec = mysqli_fetch_array($trecSet)){
					$this->Ln();
					$this->Cell(50,8,$trec[0],0,0);
			}
			
		});
		
		// Process
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(12,8,'Process',0,0,'C');

		$this->Ln();
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);
		$this->Cell(50,8,$PROCESS,0,0);

		// Constraint Management
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(40,8,'Constraint Management',0,0,'C');

		$this->Ln();
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);
		$this->Cell(50,8,$CONMM,0,0);

		// Risk Management
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(29,8,'Risk Management',0,0,'C');

		$this->Ln();
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);
		$this->Cell(50,8,$RISKMM,0,0);

		// Cost Benefit Analysis
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(36,8,'Cost Benefit Analysis',0,0,'C');

		$this->Ln();
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);
		$this->Cell(50,8,$COST,0,0);

		// Actions
		$this->Ln();
		$this->SetFont('Arial','B',11);
		$this->SetTextColor(13, 13, 13);
		$this->Cell(11,8,'Actions',0,0,'C');

		$this->SetFont('Arial','B',9);
		$this->SetTextColor(79, 78, 76);

		$asql = "SELECT ACTIONNAME FROM actions WHERE TASKID ='".$id."'";

			
			$arecSet = mysqli_query($con,$asql);
			
			while($arec = mysqli_fetch_array($arecSet)){
					$this->Ln();
					$this->Cell(50,8,$arec[0],0,0);
			}
		
}

function Footer()
{
    // Position at 1.5 cm from bottom
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','I',8);
    // Text color in gray
    $this->SetTextColor(128);
    // Page number
    $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
}





}

$id = urldecode($_GET["taskid"]);
$pdf = new PDF();
// Column headings
$header = array('Country', 'Capital', 'Area (sq km)', 'Pop. (thousands)');
// Data loading
//$data = $pdf->LoadData('countries.txt');
$pdf->SetFont('Arial','',14);
//$pdf->AddPage('L');
$pdf->SetTitle(strtoupper($name));
$pdf->SetAuthor('Codd Technology');
//$pdf->Output('D',$name.'.pdf');

$pdf->Output();
?>
